config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  if [ -e $OLD ]; then
    cp -a $OLD ${NEW}.incoming
    cat $NEW > ${NEW}.incoming
    mv ${NEW}.incoming $NEW
  fi
  config $NEW
}

preserve_perms etc/rc.d/rc.docker.new
config etc/default/docker.new
config etc/logrotate.d/docker.new

if [ -x /sbin/udevadm ]; then
  /sbin/udevadm control --reload-rules
fi

( cd usr/bin ; rm -rf docker-containerd )
( cd usr/bin ; ln -sf containerd docker-containerd )
( cd usr/bin ; rm -rf docker-containerd-ctr )
( cd usr/bin ; ln -sf ctr docker-containerd-ctr )
( cd usr/bin ; rm -rf docker-containerd-shim )
( cd usr/bin ; ln -sf containerd-shim docker-containerd-shim )
( cd usr/bin ; rm -rf docker-init )
( cd usr/bin ; ln -sf tini-static docker-init )
( cd usr/bin ; rm -rf docker-runc )
( cd usr/bin ; ln -sf runc docker-runc )
