config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

preserve_perms() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  if [ -e $OLD ]; then
    cp -a $OLD ${NEW}.incoming
    cat $NEW > ${NEW}.incoming
    mv ${NEW}.incoming $NEW
  fi
  config $NEW
}

preserve_perms etc/rc.d/rc.postgresql17.new
config etc/logrotate.d/postgresql17.new

# Create default program symlinks in /usr/bin
(
  cd usr/bin
  for pg_binary in ../lib64/postgresql17/17/bin/*; do
    pg_prog=$(basename $pg_binary)
    if [ -L $pg_prog ]; then
      ln -sf $pg_binary
    elif [ ! -e $pg_prog ]; then
      # make sure we don't overwrite actual binaries
      ln -s $pg_binary
    fi
  done
)

( cd usr/lib64 ; rm -rf libecpg.so )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libecpg.so libecpg.so )
( cd usr/lib64 ; rm -rf libecpg.so.6 )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libecpg.so.6 libecpg.so.6 )
( cd usr/lib64 ; rm -rf libecpg.so.6.17 )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libecpg.so.6.17 libecpg.so.6.17 )
( cd usr/lib64 ; rm -rf libecpg_compat.so )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libecpg_compat.so libecpg_compat.so )
( cd usr/lib64 ; rm -rf libecpg_compat.so.3 )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libecpg_compat.so.3 libecpg_compat.so.3 )
( cd usr/lib64 ; rm -rf libecpg_compat.so.3.17 )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libecpg_compat.so.3.17 libecpg_compat.so.3.17 )
( cd usr/lib64 ; rm -rf libpgtypes.so )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libpgtypes.so libpgtypes.so )
( cd usr/lib64 ; rm -rf libpgtypes.so.3 )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libpgtypes.so.3 libpgtypes.so.3 )
( cd usr/lib64 ; rm -rf libpgtypes.so.3.17 )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libpgtypes.so.3.17 libpgtypes.so.3.17 )
( cd usr/lib64 ; rm -rf libpq.so )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libpq.so libpq.so )
( cd usr/lib64 ; rm -rf libpq.so.5 )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libpq.so.5 libpq.so.5 )
( cd usr/lib64 ; rm -rf libpq.so.5.17 )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libpq.so.5.17 libpq.so.5.17 )
( cd usr/lib64 ; rm -rf libpqwalreceiver.so )
( cd usr/lib64 ; ln -sf postgresql17/17/lib/libpqwalreceiver.so libpqwalreceiver.so )
( cd usr/lib64/pkgconfig ; rm -rf libecpg.pc )
( cd usr/lib64/pkgconfig ; ln -sf ../postgresql17/17/lib/pkgconfig/libecpg.pc libecpg.pc )
( cd usr/lib64/pkgconfig ; rm -rf libecpg_compat.pc )
( cd usr/lib64/pkgconfig ; ln -sf ../postgresql17/17/lib/pkgconfig/libecpg_compat.pc libecpg_compat.pc )
( cd usr/lib64/pkgconfig ; rm -rf libpgtypes.pc )
( cd usr/lib64/pkgconfig ; ln -sf ../postgresql17/17/lib/pkgconfig/libpgtypes.pc libpgtypes.pc )
( cd usr/lib64/pkgconfig ; rm -rf libpq.pc )
( cd usr/lib64/pkgconfig ; ln -sf ../postgresql17/17/lib/pkgconfig/libpq.pc libpq.pc )
( cd usr/lib64/postgresql17/17/lib ; rm -rf libecpg.so )
( cd usr/lib64/postgresql17/17/lib ; ln -sf libecpg.so.6.17 libecpg.so )
( cd usr/lib64/postgresql17/17/lib ; rm -rf libecpg.so.6 )
( cd usr/lib64/postgresql17/17/lib ; ln -sf libecpg.so.6.17 libecpg.so.6 )
( cd usr/lib64/postgresql17/17/lib ; rm -rf libecpg_compat.so )
( cd usr/lib64/postgresql17/17/lib ; ln -sf libecpg_compat.so.3.17 libecpg_compat.so )
( cd usr/lib64/postgresql17/17/lib ; rm -rf libecpg_compat.so.3 )
( cd usr/lib64/postgresql17/17/lib ; ln -sf libecpg_compat.so.3.17 libecpg_compat.so.3 )
( cd usr/lib64/postgresql17/17/lib ; rm -rf libpgtypes.so )
( cd usr/lib64/postgresql17/17/lib ; ln -sf libpgtypes.so.3.17 libpgtypes.so )
( cd usr/lib64/postgresql17/17/lib ; rm -rf libpgtypes.so.3 )
( cd usr/lib64/postgresql17/17/lib ; ln -sf libpgtypes.so.3.17 libpgtypes.so.3 )
( cd usr/lib64/postgresql17/17/lib ; rm -rf libpq.so )
( cd usr/lib64/postgresql17/17/lib ; ln -sf libpq.so.5.17 libpq.so )
( cd usr/lib64/postgresql17/17/lib ; rm -rf libpq.so.5 )
( cd usr/lib64/postgresql17/17/lib ; ln -sf libpq.so.5.17 libpq.so.5 )
